<%@ taglib uri="http://tomcat.apache.org/taglibs/script-1.0" prefix="script" %>

<script:scriptlet language="rexx">

session = bsf.lookupBean("session")
request = bsf.lookupBean("request")
response = bsf.lookupBean("response")

id = request~getParameter("id")
firstName = request~getParameter("firstName")
lastName = request~getParameter("lastName")
birthdayCal = request~getParameter("birthday") 

/* rexx-style string tokenization */
parse var birthdayCal birthday "/" birthmonth "/" birthyear 

/* creates new instance */
birthdayCalendar = .bsf~new("java.util.GregorianCalendar") 
birthdayCalendar~set(birthyear, birthmonth - 1, birthday)

/* saves new person */
newPerson = .bsf~new("org.apache.taglibs.extended.script.samples.Person", id, firstName, lastName, birthdayCalendar)
session~getAttribute("personService")~saveOrUpdatePerson(newPerson)


/* return to start page */
response~sendRedirect("RexxController")

::REQUIRES BSF.CLS
</script:scriptlet>